/*
 * Decompiled with CFR 0.152.
 */
package com.ceb.portlet;

import com.ceb.configuration.RestClientConfiguration;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.json.JSONObject;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.ceb.configuration.RestClientConfiguration"}, immediate=true, property={"com.liferay.portlet.display-category=category.sample", "com.liferay.portlet.header-portlet-css=/css/main.css", "com.liferay.portlet.footer-portlet-javascript=/js/powerbi.js", "com.liferay.portlet.footer-portlet-javascript=/js/jsonpath.js", "com.liferay.portlet.instanceable=true", "javax.portlet.display-name=RestClient", "javax.portlet.init-param.template-path=/", "javax.portlet.init-param.view-template=/view.jsp", "javax.portlet.name=com_ceb_RestClientPortlet", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=power-user,user"}, service={Portlet.class})
public class RestClientPortlet
extends MVCPortlet {
    private static final Log logger = LogFactoryUtil.getLog(RestClientPortlet.class);
    private volatile RestClientConfiguration _config;

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._config = (RestClientConfiguration)ConfigurableUtil.createConfigurable(RestClientConfiguration.class, properties);
    }

    public void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        logger.info((Object)"inside my check registration logic controller");
        renderRequest.setAttribute("expirationEmbedToken", (Object)"02_07_2025");
        renderRequest.setAttribute("esgEmbedToken", (Object)this.getEmbedToken());
        super.doView(renderRequest, renderResponse);
    }

    public String getEmbedToken() {
        String embedToken = "";
        try {
            BufferedReader br;
            logger.info((Object)(this._config.urlEmbedToken() + "--" + this._config.urlAccessToken()));
            URL urlAccessToken = new URL(this._config.urlAccessToken());
            HttpURLConnection con = (HttpURLConnection)urlAccessToken.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            con.setRequestProperty("Accept", "application/json");
            con.setDoOutput(true);
            String urlEncodedParams = this._config.clientSecret();
            OutputStream os = con.getOutputStream();
            os.write(urlEncodedParams.getBytes());
            os.flush();
            os.close();
            int responseCode = con.getResponseCode();
            StringBuilder response = new StringBuilder();
            if (100 <= con.getResponseCode() && con.getResponseCode() <= 399) {
                br = new BufferedReader(new InputStreamReader(con.getInputStream(), "utf-8"));
            } else {
                logger.error((Object)("Error occured during Login via POST request. Http response code : " + responseCode));
                br = new BufferedReader(new InputStreamReader(con.getErrorStream(), "utf-8"));
            }
            String responseLine = null;
            while ((responseLine = br.readLine()) != null) {
                response.append(responseLine.trim());
            }
            logger.info((Object)("Access token Rest call response : " + response.toString()));
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonNode = mapper.readTree(response.toString());
            String accessToken = jsonNode.get("access_token").asText();
            String expiresOn = jsonNode.get("expires_on").asText();
            logger.info((Object)("accessToken : " + accessToken + "  expiresOn : " + expiresOn));
            URL urlEmbedToken = new URL(this._config.urlEmbedToken());
            HttpURLConnection connectionForEmbedToken = (HttpURLConnection)urlEmbedToken.openConnection();
            connectionForEmbedToken.setRequestMethod("POST");
            connectionForEmbedToken.setRequestProperty("Content-Type", "application/json");
            connectionForEmbedToken.setRequestProperty("Accept", "application/json");
            connectionForEmbedToken.setRequestProperty("Authorization", "Bearer " + accessToken);
            connectionForEmbedToken.setDoOutput(true);
            JSONObject requestEmbedBody = new JSONObject();
            requestEmbedBody.put("accessLevel", (Object)"View");
            requestEmbedBody.put("allowSaveAs", (Object)"false");
            OutputStream os1 = connectionForEmbedToken.getOutputStream();
            os1.write(requestEmbedBody.toString().getBytes("utf-8"));
            StringBuilder responseEmbed = new StringBuilder();
            br = null;
            if (100 <= connectionForEmbedToken.getResponseCode() && connectionForEmbedToken.getResponseCode() <= 399) {
                br = new BufferedReader(new InputStreamReader(connectionForEmbedToken.getInputStream(), "utf-8"));
            } else {
                logger.error((Object)("POST request via POST request. Http Error code : " + connectionForEmbedToken.getResponseCode()));
                br = new BufferedReader(new InputStreamReader(connectionForEmbedToken.getErrorStream(), "utf-8"));
            }
            responseLine = null;
            while ((responseLine = br.readLine()) != null) {
                responseEmbed.append(responseLine.trim());
            }
            logger.info((Object)("Access token Rest call response : " + responseEmbed.toString()));
            ObjectMapper mapper2 = new ObjectMapper();
            JsonNode jsonNode2 = mapper2.readTree(responseEmbed.toString());
            embedToken = jsonNode2.get("token").asText();
            String embedTokenExpiresOn = jsonNode.get("ext_expires_in").asText();
            logger.info((Object)("embedToken : " + embedToken + "  embedTokenExpiresOn : " + embedTokenExpiresOn));
            return embedToken;
        }
        catch (IOException e) {
            logger.error((Object)"Exception occured when generation Embed Token for PowerBi", (Throwable)e);
            return "";
        }
    }
}

